/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import jgamebase.Const;
import jgamebase.model.Databases;
import jgamebase.model.Emulators;
import jgamebase.model.Paths;
import jgamebase.model.Plugins;
import jgamebase.plugins.Extractor;
import jgamebase.tools.ListerTools;
import jgamebase.tools.TempDir;

public class FileTools {
    private static final int BUFFER_SIZE = 0x100000;
    private static byte[] buffer = new byte[0x100000];

    public static boolean deleteAll(File dir) {
        if (dir.isDirectory()) {
            String[] filesAndDirs;
            String[] stringArray = filesAndDirs = dir.list();
            int n = filesAndDirs.length;
            int n2 = 0;
            while (n2 < n) {
                String filesAndDir = stringArray[n2];
                if (!FileTools.deleteAll(new File(dir, filesAndDir))) {
                    return false;
                }
                ++n2;
            }
        }
        return dir.delete();
    }

    public static String insertBeforeFileextension(String filename, String insert) {
        if (filename == null) {
            return "";
        }
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return String.valueOf(filename.substring(0, dotIndex)) + insert + filename.substring(dotIndex, filename.length());
    }

    public static long checksum(String s) {
        CRC32 checksum = new CRC32();
        checksum.update(s.getBytes(), 0, s.getBytes().length);
        return checksum.getValue();
    }

    public static String getExtension(String filename) {
        if (filename == null || filename.isEmpty() || filename.lastIndexOf(".") == -1) {
            return "";
        }
        return filename.substring(filename.lastIndexOf(".") + 1, filename.length()).toLowerCase();
    }

    public static String removeExtension(String filename) {
        if (filename == null || filename.isEmpty()) {
            return "";
        }
        if (filename.lastIndexOf(".") == -1) {
            return filename;
        }
        return filename.substring(0, filename.lastIndexOf("."));
    }

    public static String removeAllExtensions(String filename) {
        if (filename == null || filename.isEmpty()) {
            return "";
        }
        String s = filename;
        while (s.lastIndexOf(".") != -1) {
            s = FileTools.removeExtension(s);
        }
        return s;
    }

    public static String getPrefix(String filename) {
        if (filename == null || filename.isEmpty() || filename.lastIndexOf(".") == -1) {
            return "";
        }
        filename = Paths.removePath(filename);
        return filename.substring(0, filename.indexOf(".")).toLowerCase();
    }

    public static String removePrefix(String filename) {
        if (filename == null || filename.isEmpty()) {
            return "";
        }
        if (!filename.contains(".")) {
            return filename;
        }
        return filename.substring(filename.indexOf(".") + 1, filename.length());
    }

    public static String changePrefixToExtension(String filename) {
        return String.valueOf(FileTools.removePrefix(filename)) + "." + FileTools.getPrefix(filename);
    }

    /*
     * Unable to fully structure code
     */
    public static String removeSpace(String filename) {
        if (filename != null) ** GOTO lbl4
        return "";
lbl-1000:
        // 1 sources

        {
            filename = filename.replace(' ', '_');
lbl4:
            // 2 sources

            ** while (filename.indexOf((int)32) != -1)
        }
lbl5:
        // 1 sources

        return filename;
    }

    public static void copyFile(File src, File dst) throws IOException {
        if (!src.exists()) {
            throw new IOException("Source file not found.");
        }
        if (!src.isFile()) {
            throw new IOException("Source isn't a file.");
        }
        if (!src.canRead()) {
            throw new IOException("Source file can't be read.");
        }
        if (dst.getParentFile() != null && !dst.getParentFile().isDirectory()) {
            dst.getParentFile().mkdirs();
        }
        if (dst.exists()) {
            if (!dst.canWrite()) {
                throw new IOException("Destination file can't be overwritten.");
            }
        } else {
            try {
                dst.createNewFile();
            }
            catch (Exception exception) {
                throw new IOException("Destination file can't be created.");
            }
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = new FileInputStream(src);
                if (in == null) {
                    throw new IOException("Could not open input stream for file '" + src + "'");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException("Could not open input stream for file '" + src + "' (probably because it is being used by another process)");
            }
            try {
                out = new FileOutputStream(dst);
                if (out == null) {
                    throw new IOException("Could not open output stream for file '" + dst + "'");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException("Could not open output stream for file '" + dst + "' (probably because access to the source file '" + src + "' is denied)");
            }
            int copied = 0;
            while ((copied = in.read(buffer)) != -1) {
                out.write(buffer, 0, copied);
            }
            long lastModified = src.lastModified();
            if (lastModified < 0L) {
                lastModified = 0L;
            }
            dst.setLastModified(lastModified);
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        catch (Exception exception) {}
    }

    public static File replacePath(File srcFile, File srcPath, File dstPath) {
        String path = srcFile.getAbsolutePath();
        String cut = path.substring(srcPath.getAbsolutePath().length(), path.length());
        if (!cut.startsWith(File.separator)) {
            cut = String.valueOf(File.separator) + cut;
        }
        String newPath = String.valueOf(dstPath.getAbsolutePath()) + cut;
        return new File(newPath);
    }

    private static File[] replacePath(File[] srcFiles, File srcPath, File dstPath) {
        File[] dstFiles = new File[srcFiles.length];
        int i = 0;
        while (i < srcFiles.length) {
            dstFiles[i] = FileTools.replacePath(srcFiles[i], srcPath, dstPath);
            ++i;
        }
        return dstFiles;
    }

    public static void copyDir(File src, File dst) throws Exception {
        if (!src.exists() || !src.isDirectory()) {
            throw new IOException("Source directory '" + src.getAbsolutePath() + "' doesn't exist or isn't a directory!");
        }
        if (dst.exists() && !dst.isDirectory()) {
            throw new IOException("Destination directory '" + dst.getAbsolutePath() + "' isn't a directory!");
        }
        FileTools._copyDir(src, dst, src);
    }

    private static void _copyDir(File src, File dst, File currentDir) throws Exception {
        File[] srcDirs = FileTools.listDirectories(currentDir);
        File[] dstDirs = FileTools.replacePath(srcDirs, src, dst);
        File[] srcFiles = FileTools.listFiles(currentDir);
        File[] dstFiles = FileTools.replacePath(srcFiles, src, dst);
        int i = 0;
        while (i < srcFiles.length) {
            FileTools.copyFile(srcFiles[i], dstFiles[i]);
            ++i;
        }
        i = 0;
        while (i < srcDirs.length) {
            FileTools._copyDir(src, dst, srcDirs[i]);
            dstDirs[i].mkdirs();
            ++i;
        }
    }

    private static void _copyDir(File src, File dst, File currentDir, String[] excludes) throws Exception {
        File[] srcDirs = FileTools.listDirectories(currentDir, excludes);
        File[] dstDirs = FileTools.replacePath(srcDirs, src, dst);
        File[] srcFiles = FileTools.listFiles(currentDir);
        File[] dstFiles = FileTools.replacePath(srcFiles, src, dst);
        int i = 0;
        while (i < srcFiles.length) {
            FileTools.copyFile(srcFiles[i], dstFiles[i]);
            ++i;
        }
        i = 0;
        while (i < srcDirs.length) {
            FileTools._copyDir(src, dst, srcDirs[i]);
            dstDirs[i].mkdirs();
            ++i;
        }
    }

    public static void copyDir(File src, File dst, String[] excludes) throws Exception {
        if (!src.exists() || !src.isDirectory()) {
            throw new IOException("Source directory '" + src.getAbsolutePath() + "' doesn't exist or isn't a directory!");
        }
        if (dst.exists() && !dst.isDirectory()) {
            throw new IOException("Destination directory '" + dst.getAbsolutePath() + "' isn't a directory!");
        }
        FileTools._copyDir(src, dst, src, excludes);
    }

    public static String readFileAsString(String filePath) throws IOException {
        StringBuilder fileData = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[0x100000];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
        }
        reader.close();
        return fileData.toString();
    }

    public static void writeStringAsFile(File file, String content) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(content);
        writer.flush();
        writer.close();
    }

    private static File[] listFiles(File dir) {
        File[] filesAndDirs = dir.listFiles();
        if (filesAndDirs == null) {
            return new File[0];
        }
        int count = 0;
        File[] fileArray = filesAndDirs;
        int n = filesAndDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File filesAndDir = fileArray[n2];
            if (filesAndDir.isFile()) {
                ++count;
            }
            ++n2;
        }
        File[] files = new File[count];
        count = 0;
        File[] fileArray2 = filesAndDirs;
        int n3 = filesAndDirs.length;
        n = 0;
        while (n < n3) {
            File filesAndDir = fileArray2[n];
            if (filesAndDir.isFile()) {
                files[count] = filesAndDir;
                ++count;
            }
            ++n;
        }
        return files;
    }

    private static File[] listDirectories(File dir) {
        File[] filesAndDirs = dir.listFiles();
        if (filesAndDirs == null) {
            return new File[0];
        }
        int count = 0;
        File[] fileArray = filesAndDirs;
        int n = filesAndDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File filesAndDir = fileArray[n2];
            if (filesAndDir.isDirectory()) {
                ++count;
            }
            ++n2;
        }
        File[] dirs = new File[count];
        count = 0;
        File[] fileArray2 = filesAndDirs;
        int n3 = filesAndDirs.length;
        n = 0;
        while (n < n3) {
            File filesAndDir = fileArray2[n];
            if (filesAndDir.isDirectory()) {
                dirs[count] = filesAndDir;
                ++count;
            }
            ++n;
        }
        return dirs;
    }

    private static File[] listDirectories(File dir, String[] excludes) {
        int n;
        boolean includeDirectory;
        File[] filesAndDirs = dir.listFiles();
        int count = 0;
        File[] fileArray = filesAndDirs;
        int n2 = filesAndDirs.length;
        int n3 = 0;
        while (n3 < n2) {
            File filesAndDir = fileArray[n3];
            includeDirectory = false;
            if (filesAndDir.isDirectory()) {
                includeDirectory = true;
                String[] stringArray = excludes;
                n = excludes.length;
                int n4 = 0;
                while (n4 < n) {
                    String exclude = stringArray[n4];
                    if (filesAndDir.getName().equals(exclude)) {
                        includeDirectory = false;
                    }
                    ++n4;
                }
            }
            if (includeDirectory) {
                ++count;
            }
            ++n3;
        }
        File[] directories = new File[count];
        count = 0;
        File[] fileArray2 = filesAndDirs;
        int n5 = filesAndDirs.length;
        n2 = 0;
        while (n2 < n5) {
            File filesAndDir = fileArray2[n2];
            includeDirectory = false;
            if (filesAndDir.isDirectory()) {
                includeDirectory = true;
                String[] stringArray = excludes;
                int n6 = excludes.length;
                n = 0;
                while (n < n6) {
                    String exclude = stringArray[n];
                    if (filesAndDir.getName().equals(exclude)) {
                        includeDirectory = false;
                    }
                    ++n;
                }
            }
            if (includeDirectory) {
                directories[count] = filesAndDir;
                ++count;
            }
            ++n2;
        }
        return directories;
    }

    public static String findInPath(String command) {
        if (command == null || command.isEmpty()) {
            return "";
        }
        String path = String.valueOf(System.getenv("PATH")) + File.pathSeparator + new File(Databases.getCurrent().getPath(), "Scripts").getAbsolutePath();
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            File file = new File(st.nextToken(), command);
            if (!file.exists()) continue;
            return file.getAbsolutePath();
        }
        return "";
    }

    public static boolean existsInPath(String command) {
        return !FileTools.findInPath(command).isEmpty();
    }

    public static String findRom(String rom) {
        if (rom == null || rom.isEmpty()) {
            return "";
        }
        String rootDirToSearch = new File(Databases.getCurrent().getPath(), "ROMs").getAbsolutePath();
        for (String potentialRom_PathAndFilename : ListerTools.list_ExistingFilesRecursive(rootDirToSearch)) {
            File potentialRom_File = new File(potentialRom_PathAndFilename);
            String potentialRom_Filename = potentialRom_File.getName();
            if (!potentialRom_Filename.equalsIgnoreCase(rom)) continue;
            return new File(potentialRom_PathAndFilename).getAbsolutePath();
        }
        return "";
    }

    public static String findRom(String[] roms) {
        if (roms == null || roms.length == 0) {
            return "";
        }
        String[] stringArray = roms;
        int n = roms.length;
        int n2 = 0;
        while (n2 < n) {
            String rom = stringArray[n2];
            String found = FileTools.findRom(rom);
            if (!found.isEmpty()) {
                return found;
            }
            ++n2;
        }
        return "";
    }

    public static boolean isAnimation(String filename) {
        if (filename == null || filename.isEmpty()) {
            return false;
        }
        return "gif".equalsIgnoreCase(FileTools.getExtension(filename));
    }

    public static boolean isUrlFromFilename(String filename) {
        return FileTools.getUrlFromFilename(filename) != null;
    }

    public static URL getUrlFromFilename(String filename) {
        URL url = null;
        File file = new File(filename);
        String ext = FileTools.getExtension(filename);
        if (("url".equalsIgnoreCase(ext) || "desktop".equalsIgnoreCase(ext)) && file.length() < 512L) {
            try {
                Const.log.info((Object)("Found possible URL file '" + filename + "'"));
                String content = FileTools.readFileAsString(filename);
                Pattern p = Pattern.compile("^[uU][rR][lL]=.*$");
                Scanner scanner = new Scanner(content);
                scanner.useDelimiter("\r\n|[\n\r\u2028\u2029\u0085]");
                while (scanner.hasNext()) {
                    String line = scanner.next();
                    Matcher m = p.matcher(line);
                    if (!m.find()) continue;
                    line = line.substring(4);
                    url = new URL(line);
                    Const.log.info((Object)("got URL '" + url + "'"));
                }
            }
            catch (MalformedURLException mfue) {
                Const.log.warn((Object)"Error parsing URL", (Throwable)mfue);
            }
            catch (IOException iOException) {}
        }
        return url;
    }

    public static List<String> copyOrExtractToTempDir(String filename) {
        return FileTools.copyOrExtractToDir(filename, TempDir.getPath().getAbsolutePath());
    }

    public static List<String> copyOrExtractToDir(String filename, String tempDir) {
        ArrayList<String> namesOfSupportedFiles = new ArrayList<String>();
        if (Plugins.existsExtractorForExtension(FileTools.getExtension(filename))) {
            List<Object> filenames = new ArrayList();
            try {
                Extractor extractor = Plugins.getExtractorForExtension(FileTools.getExtension(filename));
                filenames = extractor.extractToDir(filename, tempDir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            namesOfSupportedFiles.addAll(filenames.stream().filter(filename2 -> Emulators.getSupportedGameExtensions().contains(FileTools.getExtension(filename2))).collect(Collectors.toList()));
            Collections.sort(namesOfSupportedFiles, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return FileTools.removeExtension(Paths.removePath(((String)o1).toLowerCase())).compareTo(FileTools.removeExtension(Paths.removePath(((String)o2).toLowerCase())));
                }
            });
        } else {
            try {
                namesOfSupportedFiles.add(FileTools.copyToTempDir(filename));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return namesOfSupportedFiles;
    }

    public static String copyToTempDir(String filename) throws IOException {
        File srcFile = new File(filename);
        File dstFile = new File(TempDir.getPath(), srcFile.getName());
        System.out.println("copyToTempDir '" + srcFile + "' to '" + dstFile + "'");
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(dstFile);
            int copied = 0;
            while ((copied = in.read(buffer)) != -1) {
                out.write(buffer, 0, copied);
            }
            String string = dstFile.getAbsolutePath();
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

